<?php
header("Cache-Control: no-cache, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Access Blocked</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <style>

    body{
      margin:0;
      padding:0;
      background:#0b0e13;
      font-family: "Segoe UI", Arial, sans-serif;
      color:#fff;
      height:100vh;
      display:flex;
      align-items:center;
      justify-content:center;
    }

    .card{
      background:#11151d;
      border:1px solid rgba(255,255,255,0.08);
      padding:40px;
      width:100%;
      max-width:480px;
      text-align:center;
      border-radius:12px;
      box-shadow:0 0 45px rgba(255,0,0,0.12);
      position:relative;
    }

    /* RED WARNING GLOW */
    .card::before{
      content:"";
      position:absolute;
      top:-40px;
      left:50%;
      transform:translateX(-50%);
      width:90px;
      height:90px;
      background:radial-gradient(circle, rgba(255,0,0,0.22), rgba(0,0,0,0));
      border-radius:50%;
      filter:blur(12px);
      z-index:0;
    }

    /* Shield / Lock Icon */
    .icon{
      font-size:60px;
      color:#ff3b3b;
      margin-bottom:12px;
      text-shadow:0 0 18px rgba(255,0,0,0.45);
    }

    .title{
      font-size:26px;
      font-weight:700;
      margin:0 0 10px;
      color:#ff5d5d;
      letter-spacing:1px;
    }
    
    .text{
      font-size:15px;
      line-height:1.6;
      color:#c9d1d9;
      margin-bottom:25px;
    }

    .tag{
      display:inline-block;
      padding:6px 14px;
      background:rgba(255,0,0,0.15);
      border:1px solid rgba(255,0,0,0.30);
      border-radius:999px;
      color:#ff8a8a;
      font-weight:600;
      margin-bottom:14px;
      letter-spacing:1px;
      font-size:13px;
    }

    .btn{
      display:inline-block;
      padding:10px 20px;
      background:#ff3b3b;
      border-radius:8px;
      text-decoration:none;
      color:#fff;
      font-weight:600;
      box-shadow:0 0 12px rgba(255,0,0,0.35);
      transition:0.2s;
    }
    .btn:hover{
      background:#ff1f1f;
      box-shadow:0 0 18px rgba(255,0,0,0.55);
    }

  </style>
</head>
<body>

  <div class="card">

    <div class="icon">⚠️</div>

    <div class="title">ACCESS BLOCKED</div>

    <div class="tag">Unauthorized Request</div>

    <div class="text">
      Access attempt denied.
Your identity does not match the required authorization profile.
    </div>

    <a href="login.php" class="btn">Return to Login</a>

  </div>

</body>
</html>
