<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>DIGITAL ACCOUNTS MANAGEMENT</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="author" content="KASHIF ALI">

    <!-- Bootstrap -->
    <link rel="stylesheet" href="css/bootstrap-cerulean.min.css">
    <link rel="stylesheet" href="css/charisma-app.css">

    <style>
       /* ===== Page & Body ===== */
body{
    background:#f4f6f9;
    font-family:"Segoe UI",Tahoma,sans-serif;
    margin-top:20px;
    font-size:15px;
}

/* ===== Card ===== */
.report-card{
    background:#ffffff;
    padding:28px;
    border-radius:12px;
    box-shadow:0 8px 22px rgba(0,0,0,0.10);
}

/* ===== Report Title ===== */
#lablrpt{
    text-align:center;
    font-size:24px;
    font-weight:800;
    color:#2c3e50;
    margin-bottom:30px;
    letter-spacing:0.5px;
}

/* ===== Buttons ===== */
#printbtn{
    background:linear-gradient(45deg,#3498db,#1f6fb2);
    border:none;
    color:#fff;
    font-weight:700;
    padding:6px 14px;
    margin-right:8px;
}
#printbtn:hover{
    background:linear-gradient(45deg,#1f6fb2,#155a96);
}

#closebtn{
    background:#e74c3c;
    border:none;
    color:#fff;
    font-weight:700;
    padding:6px 14px;
}
#closebtn:hover{
    background:#c0392b;
}

/* ===== Table ===== */
table{
    width:100%;
    border-collapse:collapse;
    margin-top:18px;
}

th, td{
    border:1px solid #dcdcdc;
    padding:11px 10px;
    font-size:15px;
    font-weight:600;
    text-align:right;
}

/* ===== Table Header ===== */
th{
    background:#3498db;
    color:#ffffff;
    font-size:16px;
    font-weight:800;
    text-align:center;
    letter-spacing:0.3px;
}

/* ===== First Column (Product Name) ===== */
td:first-child{
    text-align:left;
    font-weight:700;
    font-size:15px;
}

/* ===== Hover Effect ===== */
tr:hover{
    background:#f1f8ff;
}

/* ===== Total Row ===== */
.total-row td{
    background:#ecf0f1;
    font-size:16px;
    font-weight:800;
}

/* ===== Print Styling ===== */
@media print{
    #printbtn,#closebtn{display:none;}
    body,.report-card{background:#ffffff !important;}

    th{
        background:#3498db !important;
        color:#ffffff !important;
        -webkit-print-color-adjust:exact;
    }

    tr:hover{background:transparent;}
}

    </style>

    <script src="js/jquery-1.12.4.js"></script>
</head>

<body>
<div class="container report-card">

<?php
require 'connection.php';

$from = $_GET['from'];
$to   = $_GET['to'];
?>

<div class="mb-3">
    <button class="btn btn-sm" id="closebtn">Close</button>
    <button class="btn btn-sm" id="printbtn">Print</button>
</div>

<h2 id="lablrpt">
    Sale & Stock Report<br>
    <small><?= date('d-m-Y',strtotime($from)) ?> To <?= date('d-m-Y',strtotime($to)) ?></small>
</h2>

<div class="table-responsive">
<table>
    <tr>
        <th>Product Name</th>
        <th>Opening Stock</th>
        <th>Stock In</th>
        <th>Stock Out</th>
        <th>Current Stock</th>
        <th>Avg Rate</th>
        <th>Stock Value</th>
    </tr>

<?php
$Tstockvalue = 0;

$item_qry = mysqli_query($connect,"SELECT itemid,itemname FROM itemreg ORDER BY itemname");

while($item = mysqli_fetch_assoc($item_qry)){

    $itemid = $item['itemid'];

    /* Opening Stock */
    $opstk = mysqli_fetch_assoc(mysqli_query($connect,"
        SELECT IFNULL(SUM(stockin - stockout),0) stk
        FROM stockledger
        WHERE itemid='$itemid' AND dated < '$from'
    "))['stk'];

    /* Stock In (From-To) */
    $stin = mysqli_fetch_assoc(mysqli_query($connect,"
        SELECT IFNULL(SUM(stockin),0) stin
        FROM stockledger
        WHERE itemid='$itemid'
        AND dated BETWEEN '$from' AND '$to'
    "))['stin'];

    /* Stock Out (From-To) */
    $stout = mysqli_fetch_assoc(mysqli_query($connect,"
        SELECT IFNULL(SUM(stockout),0) stout
        FROM stockledger
        WHERE itemid='$itemid'
        AND dated BETWEEN '$from' AND '$to'
    "))['stout'];

    /* ===== OLD REPORT LOGIC (ROUNDED AVG RATE) ===== */
    $currstk = 0;
    $currval = 0;
    $avgrate = 0;

    $ledger = mysqli_query($connect,"
        SELECT stockin, ratein, stockout
        FROM stockledger
        WHERE itemid='$itemid' AND dated <= '$to'
        ORDER BY dated,trid
    ");

    while($r = mysqli_fetch_assoc($ledger)){
        $stin_qty  = round($r['stockin'],2);
        $stout_qty = round($r['stockout'],2);
        $ratein    = round($r['ratein'],2);

        $currstk = round(($currstk + $stin_qty - $stout_qty),2);
        $currval += ($stin_qty * $ratein);

        if($currval > 0 && $currstk > 0){
            $currval -= ($stout_qty * round($avgrate,2));
            $avgrate = round($currval / $currstk, 2);
        }

        if($currstk == 0){
            $currval = 0;
            $avgrate = 0;
        }
    }

    if($currstk <= 0) continue;

    $Tstockvalue += $currval;
?>

<tr>
    <td style="text-align:left"><?= $item['itemname'] ?></td>
    <td><?= round($opstk,2) ?></td>
    <td  style='color: green;'><?= round($stin,2) ?></td>
    <td  style='color: red;'><?= round($stout,2) ?></td>
    <td><?= round($currstk,2) ?></td>
    <td><?= round($avgrate,2) ?></td>
    <td><?= round($currval,2) ?></td>
</tr>

<?php } ?>

<tr class="total-row">
    <td colspan="6" style="text-align:center">Total Stock Value</td>
    <td><?= round($Tstockvalue,2) ?></td>
</tr>

</table>
</div>
</div>

<script>
$('#printbtn').click(()=>window.print());
$('#closebtn').click(()=>window.close());
</script>

</body>
</html>
