<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Digital Accounts Management | Login</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="Secure login for Digital Accounts Management">

    <!-- Bootstrap & Icons -->
    <link href="css/bootstrap-cerulean.min.css" rel="stylesheet">
    <link href="css/charisma-app.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">

    <style>
        body{
            min-height:100vh;
            background: linear-gradient(135deg, #f5f6f8, #e4e6eb);
            display:flex;
            align-items:center;
            justify-content:center;
            font-family: 'Segoe UI', Tahoma, sans-serif;
        }
        .login-card{
            background:#fff;
            border-radius:18px;
            box-shadow:0 20px 40px rgba(0,0,0,.25);
            overflow:hidden;
            max-width:420px;
            width:100%;
            animation:fadeIn .8s ease-in-out;
        }
        @keyframes fadeIn{from{opacity:0;transform:translateY(60px);}to{opacity:1;transform:translateY(0);}}

        .login-header{
            background:linear-gradient(135deg,#0f2027,#203a43,#2c5364);
            color:#fff;
            padding:30px 20px;
            text-align:center;
        }
        .login-header h2{
            margin:0;
            font-weight:700;
            letter-spacing:1.5px;
            cursor:pointer;
            transition: color .4s ease, letter-spacing .4s ease, transform .4s ease;
        }
        .login-header h2:hover{
            color:#ffd369;
            letter-spacing:3px;
            transform:scale(1.03);
        }
        .login-header p{
            margin-top:6px;
            font-size:13px;
            opacity:.85;
        }
        .login-body{
            padding:30px;
        }
        .form-control{
            height:48px;
            border-radius:10px;
        }
        .input-group-addon{
            border-radius:10px 0 0 10px;
        }
        .btn-login{
            height:48px;
            border-radius:12px;
            font-weight:600;
            letter-spacing:.5px;
            transition: all .35s ease;
            position:relative;
            overflow:hidden;
        }
        .btn-login:hover{
            transform: translateY(-2px) scale(1.02);
            box-shadow:0 10px 25px rgba(0,0,0,.25);
        }
        .btn-login::after{
            content:"";
            position:absolute;
            top:0;
            left:-100%;
            width:100%;
            height:100%;
            background: linear-gradient(120deg, transparent, rgba(255,255,255,.4), transparent);
            transition: left .6s ease;
        }
        .btn-login:hover::after{
            left:100%;
        }
        .footer-text{
            text-align:center;
            font-size:12px;
            color:#777;
            margin-top:20px;
        }
    </style>
</head>
<body>

<!-- Service Fee Notice Modal -->
<div class="modal fade" id="importantModal" tabindex="-1" role="dialog">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content" style="border-radius:16px;border:0;">

      <!-- Header -->
      <div class="modal-header"
           style="background:#fff3cd;color:#856404;
                  border-bottom:1px solid #ffeeba;
                  border-radius:16px 16px 0 0;">
        <h4 class="modal-title">
          <i class="fa fa-circle-info"></i> Important Notice
        </h4>
      </div>

      <!-- Body -->
      <div class="modal-body"
           style="background:#fff9e6;color:#856404;
                  font-size:14px;line-height:1.8;">

        <!-- NOTE SECTION -->
        <div style="background:#ffffff;border-left:5px solid #f0ad4e;
                    padding:12px;border-radius:8px;margin-bottom:15px;">
          <p style="margin:0;font-weight:600;">
            As per company policy, a monthly service fee of
            <strong>Rs. 1,250</strong> is applicable for continued use
            of the accounting system.
          </p>

          <p style="margin:8px 0 0;font-size:13px;color:#6c5c00;">
            This ensures uninterrupted service, improved performance,
            and secure data management.
          </p>
        </div>

        <!-- PAYMENT SECTION -->
        <p style="font-weight:600;margin-bottom:8px;">
          Please complete the payment using any of the following methods:
        </p>

        <div style="background:#fff;border-radius:10px;
                    padding:12px;text-align:center;
                    margin-bottom:12px;
                    border:1px dashed #f0ad4e;">
          <h2 style="margin:0;font-weight:800;color:#000;">
            Rs. 1,250
          </h2>
        </div>

        <ul style="padding-left:18px;margin-bottom:10px;">
          <li><strong>JazzCash:</strong> 0320-6656062</li>
          <li><strong>EasyPaisa:</strong> 0320-6656062</li>
          <li><strong>UBL Bank:</strong> 0452-246829199</li>
        </ul>

        <div style="background:#fff3cd;border-left:4px solid #f0ad4e;
                    padding:10px;border-radius:6px;font-size:13px;">
          After payment, please send the <strong>payment slip</strong>
          with a <strong>valid transaction ID</strong> on
          <strong>WhatsApp: 0340-698991</strong>.
        </div>

      </div>

      <!-- Footer -->
      <div class="modal-footer"
           style="background:#fff3cd;border-top:1px solid #ffeeba;">
        <button type="button"
                class="btn btn-warning"
                data-dismiss="modal">
          <i class="fa fa-check-circle"></i> I Understand
        </button>
      </div>

    </div>
  </div>
</div>




<div class="login-card">
    <div class="login-header">
        <h2>PAK TRADING COMPANY</h2>
        <p>Digital Accounts Management System</p>
    </div>

    <div class="login-body">
        <form action="login.php" method="post">

            <div class="form-group">
                <div class="input-group">
                    <span class="input-group-addon"><i class="fa fa-user"></i></span>
                    <input type="text" name="username" class="form-control" placeholder="Enter Username" required>
                </div>
            </div>

            <div class="form-group">
                <div class="input-group">
                    <span class="input-group-addon"><i class="fa fa-lock"></i></span>
                    <input type="password" name="userpass" class="form-control" placeholder="Enter Password" required>
                </div>
            </div>

            <button type="submit" class="btn btn-primary btn-block btn-login">
                <i class="fa fa-sign-in-alt"></i> Login Securely
            </button>

            <div class="footer-text">
                © <?php echo date('Y'); ?> Super Soft Tech.
            </div>
        </form>
    </div>
</div>

<script src="bower_components/jquery/jquery.min.js"></script>
<script src="bower_components/bootstrap/dist/js/bootstrap.min.js"></script>


<!--<script>-->
<!--$(window).on('load', function () {-->
<!--    $('#importantModal').modal({-->
<!--        backdrop: 'static',-->
<!--        keyboard: false-->
<!--    });-->
<!--});-->
<!--</script>-->



</body>
</html>
