<?php
require 'connection.php';

$accid = $_GET['accid'];
$from  = $_GET['from'];
$to    = $_GET['to'];

/* ===== ACCOUNT INFO ===== */
$acc = mysqli_fetch_assoc(mysqli_query($connect,
    "SELECT * FROM accreg WHERE accid='$accid'"
));

/* ===== OPENING BALANCE ===== */
$op = mysqli_fetch_assoc(mysqli_query($connect,
    "SELECT IFNULL(SUM(debit)-SUM(credit),0) op
     FROM ledger WHERE accid='$accid' AND dated<'$from'"
))['op'];

$balance = $op;
$drTotal = 0;
$crTotal = 0;
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<title>Account Ledger</title>

<style>
body{font-family:Segoe UI,Tahoma;background:#f2f2f2}
.page{max-width:950px;margin:auto;background:#fff;padding:25px}

/* HEADER */
.header{
    display:flex;justify-content:space-between;align-items:center;
    border-bottom:3px solid #1b5e20;padding-bottom:10px
}
.company{display:flex;gap:15px;align-items:center}
.company img{width:90px;height:90px;object-fit:contain}
.company h2{margin:0;color:#1b5e20}
.report-title{
    background:#1b5e20;color:#fff;padding:8px 22px;
    border-radius:20px;font-size:16px
}

/* INFO */
.info{margin-top:12px;font-size:14px}
.info div{margin-bottom:4px}

/* TABLE */
table{width:100%;border-collapse:collapse;margin-top:15px;font-size:13px}
th,td{border:1px solid #aaa;padding:6px;text-align:center}
th{background:#1b5e20;color:#fff}
td.desc{text-align:left}
tfoot td{font-weight:bold;background:#f1f8f4}

/* AUDIT */
.audit{margin-top:40px;border-top:2px dashed #999;padding-top:20px}
.audit-row{display:flex;justify-content:space-between;margin-top:40px}
.audit-cell{width:30%;text-align:center;font-size:13px}
.line{margin-top:6px;border-top:1px solid #000;padding-top:4px}

/* PRINT */
@media print{
body{background:#fff}
}
</style>
</head>

<body>
<div class="page">

<!-- HEADER -->
<div class="header">
    <div class="company">
        <img src="logo.png">
        <div>
            <h2>PAK TRADING COMPANY</h2>
            <div>📞 0301-7925943 , 0345-8622202</div>
            <div>📍 Feroza</div>
        </div>
    </div>
    <div class="report-title">ACCOUNT LEDGER</div>
</div>

<!-- INFO -->
<div class="info">
    <div><b>Account Name:</b> <?= $acc['accname'] ?></div>
    <div><b>Address:</b> <?= $acc['address'] ?></div>
    <div><b>Contact:</b> <?= $acc['phone'] ?></div>
    <div><b>Period:</b> <?= date('d-m-Y',strtotime($from)) ?> to <?= date('d-m-Y',strtotime($to)) ?></div>
</div>

<!-- LEDGER TABLE -->
<table>
<thead>
<tr>
<th>Date</th>
<th>V#</th>
<th>Entry Type</th>
<th>Description</th>
<th>Debit</th>
<th>Credit</th>
<th>Balance</th>
</tr>
</thead>

<tbody>
<tr>
<td colspan="6"><b>Opening Balance</b></td>
<td><b><?= number_format($balance,2) ?></b></td>
</tr>

<?php
$q = mysqli_query($connect,
"SELECT * FROM ledger
 WHERE accid='$accid'
 AND dated BETWEEN '$from' AND '$to'
 ORDER BY dated,trid");

while($r=mysqli_fetch_assoc($q)){

    /* ===== ITEM + DESCRIPTION ===== */
    if($r['itemid'] > 0){
        $itm = mysqli_fetch_assoc(mysqli_query($connect,
            "SELECT itemname FROM itemreg WHERE itemid='".$r['itemid']."'"
        ));
        $amount = $r['qty'] * $r['rate'];
        $desc = $itm['itemname']."  (".$r['qty']." @ ".$r['rate']." = ".$amount.")";
    }else{
        $desc = $r['description'];
    }

    $balance += $r['debit'] - $r['credit'];
    $drTotal += $r['debit'];
    $crTotal += $r['credit'];
?>
<tr>
<td><?= date('d-m-Y',strtotime($r['dated'])) ?></td>
<td><?= $r['vno'] ?></td>
<td><?= $r['entrytype'] ?></td>
<td class="desc"><?= $desc ?></td>
<td><?= number_format($r['debit'],2) ?></td>
<td><?= number_format($r['credit'],2) ?></td>
<td><?= number_format($balance,2) ?></td>
</tr>
<?php } ?>
</tbody>

<tfoot>
<tr>
<td colspan="4">TOTAL</td>
<td><?= number_format($drTotal,2) ?></td>
<td><?= number_format($crTotal,2) ?></td>
<td><?= number_format($balance,2) ?></td>
</tr>
</tfoot>
</table>

<!-- AUDIT SECTION -->
<div class="audit">
<h4>Audit & Verification</h4>

<div class="audit-row">
    <div class="audit-cell">
        <b>KASHIF ALI</b>
        <div class="line">Prepared By</div>
    </div>

  

    <div class="audit-cell">
        <div style="height:18px"></div>
        <div class="line">Auditor Signature</div>
    </div>
</div>

<p style="margin-top:30px">
<b></b><br>

</p>
<div class="audit-row">
    <div class="audit-cell">
        <div style="height:18px"></div>
        <div class="line">Customer Signature & Stamp</div>
    </div>

  

    <div class="audit-cell">
        <div style="height:18px"></div>
        <div class="line">Date</div>
    </div>
</div>


</div>

</div>
</body>
</html>
